unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, StdCtrls, ExtCtrls;

const COLS =  12;
const iMAX = 200;

const colLp       =  0;
const colNazwisko =  1;
const colImie     =  2;
const colUlica    =  3;
const colKodp     =  4;
const colMiasto   =  5;
const colDataur   =  6;
const colPesel    =  7;
const colTel      =  8;
const colEmail    =  9;
const colWoj      = 10;
const colZarobek  = 11;

Type

  mRek = record
     Lp       : String;
     Nazwisko : String;
     Imie     : String;
     Ulica    : String;
     Kodp     : String;
     Miasto   : String;
     Dataur   : String;
     Pesel    : String;
     Tel      : String;
     Email    : String;
     Woj      : String;
     Zarobek  : String;
  end;


  TMainForm = class(TForm)
    Panel1: TPanel;
    imgKONIEC: TImage;
    imbBABELKOWE: TImage;
    lblINFO: TLabel;
    lblCZAS: TLabel;
    sg: TStringGrid;
    procedure imgKONIECClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure sgSelectCell(Sender: TObject; ACol, ARow: Integer; var CanSelect: Boolean);
    procedure imbBABELKOWEClick(Sender: TObject);

  private
	 GSelected : Boolean;

  public
	 procedure  SetRec(ARow : Integer; Rek : MRek);
	 procedure  GetRec(ARow : Integer; var Rek : MRek);
	 procedure  BabelSort();
	 procedure  DrawRectGrid(Rect : TRect);
	 procedure  Przypisz_lp();
	 procedure  Buduj_sg();
	 procedure  Koniec();
  end;

var
  MainForm: TMainForm;

implementation
{$R *.dfm}
{------------------------------------------------------------------------------}
procedure TMainForm.imgKONIECClick(Sender: TObject);
begin
	Koniec();
end;

procedure TMainForm.Koniec();
begin
	if Application.MessageBox('Koniec pracy', 'Uwaga', MB_ICONINFORMATION or MB_YESNO) = mrYes then
	begin
		Close();
   end;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
   GSelected := false;
end;

procedure TMainForm.FormShow(Sender: TObject);
begin
	sg.Align := alClient;

	Buduj_sg();

	sg.Col := 1;
	sg.Row := 1;
	sg.SetFocus();
end;

procedure TMainForm.Buduj_sg();
var
	ARow : Integer;
	lp   : Integer;

begin
	ARow := 0;

	sg.DefaultRowHeight := 19;

   sg.ColCount := COLS;

	// SZEROKO KOLUMN
   sg.ColWidths[ 0] :=  50;     // Lp
   sg.ColWidths[ 1] :=  50;     // Nazwisko
   sg.ColWidths[ 2] :=  50;     // Imie
   sg.ColWidths[ 3] :=  50;     // Ulica i nr
   sg.ColWidths[ 4] :=  50;     // Kod p
   sg.ColWidths[ 5] :=  50;     // Miejscowosc
   sg.ColWidths[ 6] :=  50;     // Data ur
   sg.ColWidths[ 7] :=  50;     // Pesel
   sg.ColWidths[ 8] :=  50;     // Telefon
   sg.ColWidths[ 9] :=  50;     // E-mail
   sg.ColWidths[10] :=  50;     // Wojewdztwo
   sg.ColWidths[11] :=  50;     // Zarobek

   // NAGWKI KOLUMN
   sg.Cells[ 0, ARow] := 'Lp';
   sg.Cells[ 1, ARow] := 'Nazwisko';
   sg.Cells[ 2, ARow] := 'Imi';
   sg.Cells[ 3, ARow] := 'Ulica';
   sg.Cells[ 4, ARow] := 'Kod.p';
   sg.Cells[ 5, ARow] := 'Miejsc.';
   sg.Cells[ 6, ARow] := 'Data ur';
   sg.Cells[ 7, ARow] := 'Pesel';
   sg.Cells[ 8, ARow] := 'Telefon';
   sg.Cells[ 9, ARow] := 'E-mail';
   sg.Cells[10, ARow] := 'Woj.';
   sg.Cells[11, ARow] := 'Zarobek';
   Inc(ARow);

   for lp := iMAX downto 1 do
   begin
	   sg.Cells[ 0, ARow] := IntToStr(lp);
	   sg.Cells[ 1, ARow] := IntToStr(lp);
	   sg.Cells[ 2, ARow] := IntToStr(lp);
	   sg.Cells[ 3, ARow] := IntToStr(lp);
	   sg.Cells[ 4, ARow] := IntToStr(lp);
	   sg.Cells[ 5, ARow] := IntToStr(lp);
   	sg.Cells[ 6, ARow] := IntToStr(lp);
	   sg.Cells[ 7, ARow] := IntToStr(lp);
	   sg.Cells[ 8, ARow] := IntToStr(lp);
	   sg.Cells[ 9, ARow] := IntToStr(lp);
	   sg.Cells[10, ARow] := IntToStr(lp);
	   sg.Cells[11, ARow] := IntToStr(lp);
      Inc(ARow);
      sg.RowCount := sg.RowCount + 1;
   end;

	sg.RowCount := ARow;
   // nie chc pustego ARowa na kocu
   // sg.RowCount := sg.RowCount + 1;

   sg.FixedCols := 1;
   sg.FixedRows := 1;


   // wczenie opcji
	sg.Options := [ goFixedVertLine,
                   goFixedHorzLine,
                   goVertLine,
                   goHorzLine,
                   goRangeSelect,
                   goRowSizing,
                   goColSizing,
                   goRowMoving,
                   goEditing,
                   goAlwaysShowEditor,
                   goColMoving];

end;

procedure TMainForm.Przypisz_lp();
var
	ACol : Integer;
   ARow : Integer;

begin
	ACol := 0;	// kolumna Lp
   
   for ARow := 1 to sg.RowCount-1 do
   begin
   	sg.Cells[ACol, ARow] := IntToStr(ARow);
   end;
   sg.Refresh();
end;



procedure TMainForm.sgSelectCell(Sender: TObject; ACol, ARow: Integer; var CanSelect: Boolean);
begin
	GSelected := true;
end;

procedure TMainForm.DrawRectGrid(Rect : TRect);
begin
	if GSelected then
   begin
		sg.Invalidate();
      GSelected := false;
   end;

   sg.Canvas.Brush.Style := bsClear;
   sg.Canvas.Pen.Color   := clBlack;
   sg.Canvas.Pen.Width   := 2;
   sg.Canvas.Rectangle(Rect.Left, Rect.Top, Rect.Right, Rect.Bottom);
end;

procedure TMainForm.GetRec(ARow : Integer; var Rek : MRek);
begin
   Rek.Lp       := sg.Cells[colLp      , ARow];
   Rek.Nazwisko := sg.Cells[colNazwisko, ARow];
   Rek.Imie     := sg.Cells[colImie    , ARow];
   Rek.Ulica    := sg.Cells[colUlica   , ARow];
   Rek.Kodp     := sg.Cells[colKodp    , ARow];
   Rek.Miasto   := sg.Cells[colMiasto  , ARow];
   Rek.Dataur   := sg.Cells[colDataur  , ARow];
   Rek.Pesel    := sg.Cells[colPesel   , ARow];
   Rek.Tel      := sg.Cells[colTel     , ARow];
   Rek.Email    := sg.Cells[colEmail   , ARow];
   Rek.Woj      := sg.Cells[colWoj     , ARow];
   Rek.Zarobek  := sg.Cells[colZarobek , ARow];
end;

procedure TMainForm.SetRec(ARow : Integer; Rek : MRek);
begin
   sg.Cells[colLp      , ARow] := Rek.Lp;
   sg.Cells[colNazwisko, ARow] := Rek.Nazwisko;
   sg.Cells[colImie    , ARow] := Rek.Imie;
   sg.Cells[colUlica   , ARow] := Rek.Ulica;
   sg.Cells[colKodp    , ARow] := Rek.Kodp;
   sg.Cells[colMiasto  , ARow] := Rek.Miasto;
   sg.Cells[colDataur  , ARow] := Rek.Dataur;
   sg.Cells[colPesel   , ARow] := Rek.Pesel;
   sg.Cells[colTel     , ARow] := Rek.Tel;
   sg.Cells[colEmail   , ARow] := Rek.Email;
   sg.Cells[colWoj     , ARow] := Rek.Woj;
   sg.Cells[colZarobek , ARow] := Rek.Zarobek;
end;

procedure TMainForm.imbBABELKOWEClick(Sender: TObject);
var
	t1, t2, t3 : TTime;

begin
	lblINFO.Visible := true;

   t1 := Time();
	lblINFO.Refresh();

   BabelSort();

   t2 := Time();
   t3 := t2 - t1;

	lblINFO.Visible := false;

	lblCZAS.Caption := 'Czas trwania sortowania metod bbelkow: ' + TimeToStr(t3);
	lblCZAS.Visible := true;
end;

procedure TMainForm.BabelSort();
var
	iRows : Integer;
   I     : Integer;
   ARow  : Integer;
   ten   : MRek;
   pop   : MRek;
   nast  : MRek;
   temp  : MRek;

begin
	iRows := sg.RowCount-1;

	for I := iRows downto 1 do
   begin
   	for ARow := 1 to iRows-1 do
      begin
         GetRec(ARow, ten);
         GetRec(ARow+1, nast);

      	if StrToInt(ten.Nazwisko) > StrToInt(nast.Nazwisko) then
         begin
         	GetRec(ARow, temp);

            SetRec(ARow, nast);
            SetRec(ARow+1, ten);
         end;
      end;
   end;
end;

end.

